/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.octostudios.reliquified_ars_nouveau.mixin;

import com.hollingsworth.arsnouveau.common.entity.EntityChimeraProjectile;
import it.hurts.octostudios.reliquified_ars_nouveau.init.ItemRegistry;
import it.hurts.octostudios.reliquified_ars_nouveau.items.back.SpikedCloakItem;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import it.hurts.sskirillss.relics.utils.MathUtils;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.EntityHitResult;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={EntityChimeraProjectile.class})
public abstract class ChimeraProjectileMixin {
    @ModifyVariable(method={"onHitEntity"}, at=@At(value="STORE"), ordinal=0)
    private float modifyDamage(float originalDamage) {
        SpikedCloakItem relic;
        EntityChimeraProjectile spike = (EntityChimeraProjectile)this;
        Entity entity = spike.getOwner();
        if (!(entity instanceof Player)) {
            return originalDamage;
        }
        Player player = (Player)entity;
        ItemStack stack = EntityUtils.findEquippedCurio((Entity)player, (Item)((Item)ItemRegistry.SPIKED_CLOAK.value()));
        Item item = stack.getItem();
        if (!(item instanceof SpikedCloakItem) || !(relic = (SpikedCloakItem)item).isAbilityUnlocked(stack, "spikes")) {
            return originalDamage;
        }
        return (float)(MathUtils.round((double)relic.getStatValue(stack, "spikes", "damage"), (int)0) * (double)relic.getCount(stack));
    }

    @Inject(method={"onHitEntity"}, at={@At(value="HEAD")}, cancellable=true)
    protected void hitEntity(EntityHitResult rayTraceResult, CallbackInfo ci) {
        block3: {
            block2: {
                EntityChimeraProjectile spike = (EntityChimeraProjectile)this;
                Entity entity = spike.getOwner();
                if (!(entity instanceof Player)) break block2;
                Player player = (Player)entity;
                if (rayTraceResult.getEntity().getUUID().equals(player.getUUID())) break block3;
            }
            return;
        }
        ci.cancel();
    }
}

